local assets=
{
	
	Asset("ANIM", "anim/brscanno.zip"),
	Asset("ANIM", "anim/swap_brscanno.zip"),

  
    Asset("ATLAS", "images/inventoryimages/brscanno.xml"),
}

local prefabs = 
{
    "canno_projectile", 
}

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_brscanno", "swap_icestaff")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")

end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end



local function fn(Sim)


	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter() 

    ---- 
    MakeInventoryPhysics(inst)
    
    anim:SetBank("icestaff")
    anim:SetBuild("brscanno")
    anim:PlayAnimation("idle")
    
    inst:AddTag("icestaff")
    inst:AddTag("rangediceweapon")
  
    local function canattack(inst, target)
    if GetPlayer().components.inventory:Has("bullet", 1) and TheInput:IsMouseDown(MOUSEBUTTON_RIGHT) then
       inst.components.weapon:LaunchProjectile(inst, target)
    end
    if GetPlayer().components.inventory:Has("bullet", 1) then
       return true
    end
end
local function onattack_gun(inst, owner, target)
    if owner.components.sanity and owner.components.sanity:GetPercent() < 1.1 and not target:HasTag("wall") then
        owner.components.sanity:DoDelta(-1)        
    end
    owner.SoundEmitter:PlaySound("dontstarve/creatures/eyeballturret/shotexplo")
    SpawnPrefab("die_fx").Transform:SetPosition(target.Transform:GetWorldPosition())
    TheCamera:Shake("FULL", 0.2, 0.02, .5, 40)
    owner.components.inventory:ConsumeByName("bullet", 1)
end
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(150)
    inst.components.weapon:SetRange(10, 15)
    inst.components.weapon:SetOnAttack(onattack_gun)
    inst.components.weapon:SetCanAttack(canattack)
    inst.components.weapon:SetProjectile("canno_projectile")
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(300)
    inst.components.finiteuses:SetUses(300)
    
    inst.components.finiteuses:SetOnFinished( onfinished )
    --inst.components.weapon.quickAttack=true  --
	
    
    -------
    
    

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/brscanno.xml"
 
   inst:AddComponent("dapperness")
    inst.components.dapperness.dapperness = TUNING.CRAZINESS_MED,

    inst:AddComponent("equippable")
	--inst.components.equippable.walkspeedmult = 1.2, --ƶ



    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    inst:DoPeriodicTask(1/100, function()
    if inst.components.equippable.isequipped then
    if not GetPlayer().components.inventory:Has("bullet", 1) then
    inst:DoTaskInTime(0.5, function() GetPlayer().components.inventory:DropItem(inst)
        end) 
    end
end
end) 
    return inst
end

STRINGS.NAMES.BRSCANNO = "AK rifle"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BRSCANNO = "Only use it in critical situation."

return Prefab( "common/inventory/brscanno", fn, assets, prefabs) 
